<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class File extends Model 
{

    protected $table = 'files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('model_type', 'model_id', 'path', 'tag', 'file_name', 'notes', 'order', 'is_active', 'softDeletes');

    public function modelable()
    {
        return $this->morphTo();
    }

}